#!/bin/bash
#
# Script feito por Talles C. Goncalves com o proposito de automatizar a instalacao personalizada
# do Fedora, a partir de uma INSTALACAO MINIMA da ISO Everything:
#
# https://dl.fedoraproject.org/pub/fedora/linux/releases/32/Everything/x86_64/iso/
#
# Faça a instalacao padrao com a selecao minimia de programas, reinicie a maquina e
# plugue o cabo de rede para facilitar o processo. Copie o script para sua /home,
# defina-o como executavel e rode-o com SUDO!!

#Desativando repositórios Modular para updates mais rápidos
dnf config-manager --disable *-modular

# Adicionando repositórios RPM Fusion, Fedora Workstation e Cisco Openh264
dnf install -y https://download1.rpmfusion.org/free/fedora/rpmfusion-free-release-$(rpm -E %fedora).noarch.rpm
dnf install -y https://download1.rpmfusion.org/nonfree/fedora/rpmfusion-nonfree-release-$(rpm -E %fedora).noarch.rpm
dnf config-manager -y --set-enabled fedora-cisco-openh264

# Instalando o Xorg base (suporte para VGA intel, radeon e nouveau)
dnf install -y @base-x

# Caso vc tenha VGA AMD mais recente
dnf install -y xorg-x11-drv-amdgpu

# Para CPU Intel instale tmbm o Microcode
dnf install -y microcode_ctl iucode-tool

# Instalando pacote basico com Chromium e KDE Plasma sem Discover
dnf install -y plasma-desktop kde-l10n-pt_BR breeze-gtk kde-gtk-config plasma-nm plasma-nm-pptp ModemManager NetworkManager-adsl NetworkManager-bluetooth NetworkManager-ppp NetworkManager-pptp NetworkManager-team NetworkManager-wwan NetworkManager-wifi firewall-config konsole kdialog plasma-user-manager kaccounts-integration kaccounts-providers kio-gdrive dolphin kdeplasma-addons kate ark nano kdeconnectd bluedevil colord-kde kgamma gwenview kcalc kcm_systemd plymouth-kcm kcron kde-partitionmanager fuse fuse3 ifuse ntfs-3g btrfs-progs exfat-utils f2fs-tools zfs-fuse kde-print-manager kinfocenter kscreen ksysguard kwalletmanager5 spectacle okular cups cups-pdf bluez-cups zip unzip chromium kpipewire libpipeline pipewire pipewire-alsa pipewire-gstreamer pipewire-jack-audio-connection-kit pipewire-jack-audio-connection-kit-libs pipewire-libs pipewire-pulseaudio pipewire-utils kdesu kf5-sonnet kf5-sonnet-ui kf5-sonnet-core system-config-language adwaita-cursor-theme adwaita-gtk2-theme adwaita-icon-theme breeze-cursor-theme breeze-icon-theme desktop-backgrounds-compat f38-backgrounds-base f38-backgrounds-kde fedora-logos dnfdragora wget pciutils usbutils libva libvdpau-va-gl libva-vdpau-driver mesa-va-drivers mesa-vdpau-drivers intel-gpu-tools intel-media-driver libva-utils libva-intel-driver libva-intel-hybrid-driver kcm_systemd btrfs-progs fuse fuse3 ifuse ntfs-3g exfatprogs f2fs-tools zfs-fuse gvfs-mtp tar unrar zip unzip neofetch testdisk inxi

dnf swap -y mesa-va-drivers mesa-va-drivers-freeworld
dnf swap -y mesa-vdpau-drivers mesa-vdpau-drivers-freeworld

# Ativando o sddm e definindo como padrão
dnf install -y sddm sddm-kcm sddm-breeze kde-settings-sddm
systemctl enable sddm
systemctl set-default graphical.target

# Configurando video Intel
rm /usr/share/X11/xorg.conf.d/10-intel.conf
echo -e 'Section "OutputClass"\n	Identifier "intel"\n	MatchDriver "intel"\n	Driver "intel"\n	Option "AccelMethod" "SNA"\n	Option "TripleBuffer" "true"\n	Option "TearFree" "true"\n	Option "DRI" "3"\nEndSection' | tee -a /usr/share/X11/xorg.conf.d/10-intel.conf

# Melhorias tab completion
echo -e '\nset show-all-if-ambiguous on\nset completion-ignore-case on\nset colored-completion-prefix on' | tee -a /etc/inputrc

# Setando o uso do swap somente apos 90% da ram usada
echo -e '\n# To change the swappiness value to 10%\nvm.swappiness=10' | tee -a /usr/lib/sysctl.d/50-default.conf

# Instalando e Configurando o Powerline
dnf install -y powerline powerline-fonts
echo -e '\n#Powerline\nif [ -f `which powerline-daemon` ]; then\n  powerline-daemon -q\n  POWERLINE_BASH_CONTINUATION=1\n  POWERLINE_BASH_SELECT=1\n  . /usr/share/powerline/bash/powerline.sh\nfi' | tee -a ~/.bashrc

reboot
